<?php
/**
 * Ticket Support
 * https://webenginecms.org/
 * 
 * @version 1.4.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

$extra_admincp_sidebar[] = array(
	'Ticket Support', array(
		array('Settings','ticketsystem&page=settings'),
		array('Open Tickets','ticketsystem&page=otickets'),
		array('Closed Tickets','ticketsystem&page=ctickets'),
	)
);

function tSys_checkTables() {
	$database = Connection::Database('Me_MuOnline');
	
	$check_1 = $database->query_fetch("SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'WEBENGINE_PLUGIN_TICKETSYSTEM'");
	if(!$check_1) {
		$ticketSys_tb1 = "CREATE TABLE [dbo].[WEBENGINE_PLUGIN_TICKETSYSTEM](
			[id] [int] IDENTITY(1,1) NOT NULL,
			[ticket_subject] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
			[ticket_author] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
			[ticket_create_date] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
			[ticket_last_reply_date] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
			[ticket_last_reply_user] [varchar](50) COLLATE Chinese_PRC_CI_AS NULL,
			[ticket_status] [int] NOT NULL CONSTRAINT [DF_WEBENGINE_PLUGIN_TICKETSYSTEM_ticket_status]  DEFAULT ((0))
		) ON [PRIMARY]";
		$create_1 = $database->query($ticketSys_tb1);
		
		if($create_1) {
			message('success','Table WEBENGINE_PLUGIN_TICKETSYSTEM created!');
		} else {
			message('error','Could not create table WEBENGINE_PLUGIN_TICKETSYSTEM: '.$database->error.'');
		}
	}
	
	$check_2 = $database->query_fetch("SELECT * FROM INFORMATION_SCHEMA.TABLES where TABLE_NAME = 'WEBENGINE_PLUGIN_TICKETSYSTEM_CONTENT'");
	if(!$check_2) {
		$ticketSys_tb2 = "CREATE TABLE [dbo].[WEBENGINE_PLUGIN_TICKETSYSTEM_CONTENT](
			[reply_id] [int] IDENTITY(1,1) NOT NULL,
			[ticket_id] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
			[reply_author] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
			[reply_date] [varchar](50) COLLATE Chinese_PRC_CI_AS NOT NULL,
			[reply_content] [text] COLLATE Chinese_PRC_CI_AS NOT NULL
		) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]";
		$create_2 = $database->query($ticketSys_tb2);
		
		if($create_2) {
			message('success','Table WEBENGINE_PLUGIN_TICKETSYSTEM_CONTENT created!');
		} else {
			message('error','Could not create table WEBENGINE_PLUGIN_TICKETSYSTEM_CONTENT: '.$database->error.'');
		}
	}
}

